﻿function ProChart_InitCurrentLayout(chartObject) {
    var objChartMain = chartObject;

    var objCurrentLayout = {
        layout: null,
        toolbars: null,
        menus: null,
        headers:null,
        panels: null,
        zooms: null,
        mode:null,
        patterns: {
            containter: null,
            top: null,
            left: null,
            right: null,
            bottom: null,
            main: null,
            mainchart: null,
            row: null
        },
        chart: {
            layoutiid: null,
            parent: null,
            width: 0,
            height: 0,
            top:0,
            left:0
        },
        workmode: {
            fullscreen: false,
            alwaysfullscreen: false
        },
        timeframeview:"text" // icon/text
    };


    objChartMain.currenlayout = objCurrentLayout;


//#region layout structure
    objCurrentLayout.layout = {
        width: 900,
        height: 600,
        name: 'layout',
        items: [
            {
                type: "top",
                height: 'inherit',
                width: 'inherit',
                view: true,
                style: '',
                css: '',
                content: 'top',
                items: [
                    {
                        type: 'row',
                        name: 'toolbar',
                        height: 55,
                        width: 'inherit',
                        view: true,
                        style: '',
                        css: '',
                        content: 'row1',
                        items: [
                            { type: 'toolbar', id: "toolbar1" }
                           
                        ]
                    }
                     
                ]
            },
            {
                type: "left",
                width: '40',
                height: 'inherit',
                view: false,
                style: '',
                css: '',
                content: 'left',
                items: [
                    {
                        type: 'col',
                        name: 'toolbar1',
                        height: 'inherit',
                        width: 'inherit',
                        view: true,
                        style: '',
                        css: '',
                        content: 'col',
                        items: [
                            {  }
                        ]
                    },
                    {
                        type: 'col',
                        name: 'colleftmode3',
                        height: 'inherit',
                        width: 'inherit',
                        view: false,
                        style: '',
                        css: '',
                        content: 'col1',
                        items: [
                            {  }
                        ]
                    }
                ]
            },
            {
                type: "right",
                width: '0',
                height: 'inherit',
                view: false ,
                style: '',
                css: '',
                content: 'right',
                items: [
                    {   }
                ]
            },
            {
                type: "main",
                width: 'inherit',
                height: 'inherit',
                style: '',
                css: '',
                content: 'main',
                items: [
                    { type: 'chartcore', id: "chart_panel" },
                    {
                        type: "bottom",
                        width: 'inherit',
                        height: 80,
                        view: false,
                        style: '',
                        css: '',
                        content: 'bottom',
                        name:"mainbottom",
                        items: [
                              {
                                type: 'row',
                                name: 'zoomrow',
                                height: 60,
                                width: 'inherit',
                                style: '',
                                css: '',
                                content: 'row22',
                                items: [
                                    { type: 'zoom', id: "zoom1" }
                                ]
                            }
                        ]
                    }
                ]
            },
            {
                type: "bottom",
                width: 'inherit',
                height: 40,
                view: false,
                style: '',
                css: '',
                content: 'bottom',
                items: []
            }
        ]
    };
//#endregion layout structure

//#region toolbar

    objCurrentLayout.toolbars = [
        {
            name: "toolbar",
            id: "toolbar1",
            location:'horizontal',
            more: {
                auto: true,
                captionview: true,
                spaceview: true, 
                closebyclick: true,
                possition: "bottom",
                alignv: "auto",
                alignh: "auto",
                columns: 1
            },
            items: [
                
                  {
                     type: "button-group",
                     id: "group-charttype",
                     localize: "menu.charttype.candlesticks",
                     icon: "candlesticks",
                     caption: "candlesticks",
                     group: {
                         type: "tooltip",
                         possition: "bottom",
                         alignv: "auto",
                         alignh: "auto",
                         columns: 2,
                         css: "",
                         closebyclick: true,
                         changegroupicon: true,
                         grouptype: "charttype"
                     },
                     items: [
                               { type: "button-group-charttype", id: "charttype" } 
                     ]
                   },
                    {
                        type: "button-group",
                        id: "group-timescale",
                        localize: "menu.timescale.1T",
                        icon: "tick",
                        caption: "tick",
                        title1:"",
                        title2:"",
                        group: {
                            type: "tooltip",
                            possition: "bottom",
                            alignv: "auto",
                            alignh: "auto",
                            columns: 3,
                            css: "",
                            closebyclick: true,
                            changegroupicon: true,
                            grouptype: "timescale",
                            viewtype:"text"
                        },
                        items: [
                            { type: "button-group-timeframe", id: "timeframe" } 

                        ]
                    },
                {
                    type: "button-group",
                    id: "group-draw",
                    localize: "tools.draw.draw_raylineright",
                    icon: "ray-line",
                    caption: "ray-line",
                    group: {
                        type: "tooltip",
                        possition: "bottom",
                        alignv: "auto",
                        alignh: "auto",
                        columns: 3,
                        css: "",
                        closebyclick: true,
                        changegroupicon: true
                    },
                    items: [
                        { type: "button", id: "draw_rayline", localize: "tools.draw.draw_raylineright", icon: "ray-line", caption: "Ray" },
                        { type: "button", id: "draw_vline", localize: "tools.draw.draw_raylineright", icon: "vertical-line", caption: "Vertical Line" },
                        { type: "button", id: "draw_hline", localize: "tools.draw.draw_hline", icon: "horizontal-line", caption: "Horizontal Line" },
                        { type: "button", id: "draw_extendedline", localize: "tools.draw.draw_extendedline", icon: "extended-line", caption: "Extended line" },
                        { type: "button", id: "draw_arrow", localize: "tools.draw.draw_arrow", icon: "arrow", caption: "Arrow" },
                        { type: "button", id: "draw_line", localize: "tools.draw.draw_line", icon: "trendline", caption: "Trend line" },
                        { type: "button", id: "draw_measure", localize: "tools.draw.draw_measure", icon: "measure", caption: "Measure" },
                        { type: "button", id: "draw_parallel", localize: "tools.draw.draw_parallel", icon: "parallel-lines", caption: "Parallel line" }
                    ]
                },
            {
                type: "button-group",
                id: "group-9",
                localize: "tools.indicator.title",
                icon: "",
                caption: "Studies",
                title1: "St.",
                title2: "",
                group: {
                    type: "menu",
                    possition: "bottom",
                    alignv: "auto",
                    alignh: "auto",
                    columns: 2,
                    css: "",
                    closebyclick: true,
                    changegroupicon: false,
                    viewtype: "text"
                },
                items: [
//                    { type: "item", id: "macd", localize: "tools.indicator.macd", icon: "", caption: " MACD", action: "add-indicator" },
//                    { type: "item", id: "rsi", localize: "tools.indicator.rsi", icon: "", caption: "RSI", action: "add-indicator" },
//                    { type: "item", id: "bbands", localize: "tools.indicator.bbands", icon: "", caption: "BBANDS", action: "add-indicator" },
//                    { type: "item", id: "ichimoku", localize: "tools.indicator.ichimoku", icon: "", caption: " Ichimoku", action: "add-indicator" },
//                    { type: "item", id: "donchian", localize: "tools.indicator.donchian", icon: "", caption: "Donchian", action: "add-indicator" },
                    { type: "button-group-indicator", id:"indicators"}
                ]
              },
              { type: "button", id: "delete_allshapes", localize: "tools.tools.delete_allshapes", icon: "delete-shapes", caption: "Delete All Shapes" },
              { type: "button", id: "delete_allstudies", localize: "tools.tools.delete_allstudies", icon: "delete-indicators", caption: "Delete All Studies" }
                
                
         ]
        } 
         
 
        
    ];

    //#endregion toolbar

//#region panel
    objCurrentLayout.chart_panels = {
        id: "chart_panel",
        unit: "px",
        padding: [0, 0, 0, 0],
        spiltmargin: [0, 0, 0, 0],
        margin: [0, 0, 0, 0],
        price: {
            grow: 4,
            axisy: {
                view: true,
                top: 20,
                width: 55,
                right: 0,
                padding: [0, 0, 0, 0]
            },
            axisx: {
                view: true,
                height: 27,
                right: 55,
                bottom: 0,
                padding: [0, 0, 0, 0]
            },
            main: {
                top: 20,
                left: 0,
                right: 55,
                bottom: 27,
                padding: [0, 0, 0, 0]
            },
            legend: {
                view: true,
                height: 'inherit',
                top: 12,
                left: 23,
                right: 110,
                padding: [0, 0, 0, 0]
            },
            controlpanel: {
                view: true,
                height: 16,
                width: 43,
                right: 65,
                top: 2
            },
            zoom: {
                view: false,
                height: 40,
                bottom: 40,
                width: 185,
                left: 'center',
                right: 'center',
                padding: [0, 0, 0, 0]
            }
        },
        study: {
            grow: 1,
            axisy: {
                top: 0,
                bottom: 0,
                view: true,
                width: 55,
                right: 0,
                padding: [0, 0, 0, 0]
            },
            axisx: {
                view: false,
                height: 0,
                right: 55,
                bottom: 0,
                padding: [0, 0, 0, 0]
            },
            main: {
                top: 0,
                left: 0,
                right: 55,
                bottom: 0,
                padding: [0, 0, 0, 0]
            },
            legend: {
                view: true,
                height: 16,
                top: 2,
                left: 3,
                right: 110,
                padding: [0, 0, 0, 0]
            },
            controlpanel: {
                view: true,
                height: 16,
                width: 43,
                right: 65,
                top: 2
            }
        },
        splitterx: {
            grow: 0,
            height: 0,
            main: {
                top: -6,
                view: true,
                left: 0,
                right: 0,
                bottom: 0,
                height: 10,
                padding: [0, 0, 0, 0]
            }
        },
        signal: {
            grow: 1,
            main: {
                top: 18,
                left: 0,
                right: 0,
                bottom: 0,
                padding: [0, 0, 0, 0]
            },
            legend: {
                view: true,
                height: 16,
                top: 2,
                left: 3,
                right: 110,
                padding: [0, 0, 0, 0]
            },
            controlpanel: {
                view: true,
                height: 16,
                width: 43,
                right: 65,
                top: 2
            },
            alert: {
                view: true,
                top: 0,
                left: 0,
                bottom: 0,
                right: 0,
                padding: [0, 0, 0, 0]
            }
        }
    };
//#endregion panel

//#region menu
    objCurrentLayout.menus = {
        click: true,
        hover: false,
        closebyclick:true,
        items: [
            {
               name: "menu",
               id: "mainmenu",

            more: {
                auto: true,
                captionview: true,
                spaceview: true,
                possition: "bottom",
                possition_sub1: "left",
                alignv: "auto",
                alignh: "auto"
            },
            items: [
                {
                    type: "menu-item-group",
                    id: "majors",
                    caption: "Majors",
                    localize: "menu.majors.title",
                    group: {
                        possition: "bottom",
                        alignv: "auto",
                        alignh: "auto",
                        columns: 1,
                        css: ""
                    },
                    items: [
                        { type: 'menu-group-majors', id: "group-majors" },
                        { type: 'menu-item', id: "menu-majorform", caption: "More majors", localize: "menu.majors.openmajors" },
                        { type: 'menu-item', id: "menu-headersymbolsearch", caption: "Search", localize: "menu.majors.symbolsearch" }
                    ]
                },
                {
                    type: "menu-item-group",
                    id: "charttype",
                    caption: "Chart type",
                    localize: "menu.charttype.title",
                    group: {
                        possition: "bottom",
                        alignv: "auto",
                        alignh: "auto",
                        columns: 1,
                        css: ""
                    },
                    items: [
                        { type: 'menu-group-charttype', id: "group-charttype", favorites: true, icons: true }
                    ]
                },
                {
                    type: "menu-item-group",
                    id: "timeframe",
                    caption: "Time scales",
                    localize: "menu.timescale.title",
                    group: {
                        possition: "bottom",
                        alignv: "auto",
                        alignh: "auto",
                        columns: 1,
                        css: ""
                    },
                    items: [
                        { type: 'menu-group-timeframe', id: "group-timeframe", favorites: true, icons: true }
                    ]
                },
                {
                    type: "menu-item-group",
                    id: "studies",
                    caption: "Studies",
                    localize: "menu.indicators.title",
                    group: {
                        possition: "bottom",
                        alignv: "auto",
                        alignh: "auto",
                        columns: 1,
                        css: ""
                    },
                    items: [
                        { type: 'menu-group-indicators', id: "group-indicators" },
                        { type: 'menu-item', id: "menu-indicatorform", caption: "Indicators:", localize: "menu.indicators.openindicators" }
                    ]
                },
                {
                    type: "menu-item-group",
                    id: "compares",
                    caption: "Compare",
                    localize: "menu.compares.title",
                    group: {
                        possition: "bottom",
                        alignv: "auto",
                        alignh: "auto",
                        columns: 1,
                        css: ""
                    },
                    items: [
                        { type: 'menu-group-compares', id: "group-compares" },
                        { type: 'menu-item', id: "menu-compareform", caption: "Compare wizard:", localize: "menu.compares.opencompares" }
                    ]
                },
                {
                    type: "menu-item-group",
                    id: "localization",
                    caption: "Localization",
                    localize: "menu.localization.title",
                    group: {
                        possition: "bottom",
                        alignv: "auto",
                        alignh: "auto",
                        columns: 1,
                        css: ""
                    },
                    items: [
                        { type: 'menu-group-localizations', id: "group-localizations" }
                    ]
                },
                {
                    type: "menu-item-group",
                    id: "templates",
                    caption: "Templates",
                    localize: "menu.templates.title",
                    group: {
                        possition: "bottom",
                        alignv: "auto",
                        alignh: "auto",
                        columns: 1,
                        css: ""
                    },
                    items: [
                        { type: 'menu-item', action: 'a-change-template', id: 'defaulttemplate', caption: 'Default template' },
                        { type: 'menu-item', action: 'a-change-template', id: 'blacktemplate', caption: 'Black template' }
         
                    ]
                },
                { type: "menu-item", id: "about", caption: "About", localize: "menu.about.title" },
                { type: "menu-item", id: "help", caption: "Help", localize: "menu.help.title" }
            ]
        }
    ]};

//#endregion menu

//#region header
    objCurrentLayout.headers = [{
            id: "header1",
            unit: "px",
            items: [
                {
                    type:'searchbutton',  
                    possition: {
                        height: 'auto',
                        width: 'auto',
                        right: 'auto',
                        left: 0,
                        top: 'auto',
                        bottom: 'auto',
                        view: true,
                    }
                },
                {
                    type: 'symboltitle',
                    possition: {
                        height: 'auto',
                        width: 'auto',
                        right: 'auto',
                        left: 35,
                        top: 'auto',
                        bottom: 'auto',
                        view: true,
                    }
                },
                {
                    type:'searchsymbol',
                    search: true,
                    select:true,
                    possition: {
                        height: 'auto',
                        width: 'auto',
                        right: 'auto',
                        left: 35,
                        top: 'auto',
                        bottom: 'auto',
                        view: true,
                    }
                },
                {
                    type:'timeframe', 
                    relativeobject:'symboltitle',
                    relativepossition:'right',
                    possition: {
                        height: 'auto',
                        width: 'auto',
                        right: 'auto',
                        left: 10,
                        top: 'auto',
                        bottom: 'auto',
                        view:true
                    }
                },
                {
                    type:'communic', 
                    possition: {
                        height: 'auto',
                        width: 'auto',
                        right: 0,
                        left: 'auto',
                        top: 'auto',
                        bottom: 'auto',
                        view: true
                    }
                },
                {
                    type:'lastupdate', 
                    possition: {
                        height: 'auto',
                        width: 'auto',
                        right: 25,
                        left: 'auto',
                        top: 'auto',
                        bottom: 'auto',
                        view: true
                    }
                },
                {
                    type: 'htmlcontainer',
                    id:'htm11',
                    content:"",
                    possition: {
                        height: 'auto',
                        width: 'auto',
                        right: 225,
                        left: 'auto',
                        top: 'auto',
                        bottom: 'auto',
                        view: true
                    }
                }
            ]
    }];
//#endregion header


//#region zoom
objCurrentLayout.zooms = [{
    id: "zoom1",
    unit: "px",
    items: [
    {
        type: 'chart_container',
        possition: {
            height: 25,
            width: 'auto',
            right: 0,
            left: 0,
            top: 18,
            bottom: 'auto',
            view: true,
        }
    },    
    {
        type: 'slider1',
        possition: {
            height:  30,
            width: 'auto',
            right: 20,
            left: 20,
            top: 50,
            bottom: 'auto',
            view: false
        }
    },
    {
        type: 'daterange',
        possition: {
            height: 10,
            width: 200,
            right: 10,
            left: 'auto',
            top: 'auto',
            bottom: 'auto',
            view: true 
        }
    }
]
}];
//#endregion zoom


//mode
    objCurrentLayout.mode = {
        items: [
            {
                id:"mode1",
                tasks:[
                    {type:"row", name:"header", actions:[ 
                          {action:'hide', properties:{}}]
                    },
                    {type:"row", name:"menu", actions:[ 
                          {action:'hide', properties:{}}]
                    },
                    {type:"row", name:"toolbar", actions:[ 
                          {action:'hide', properties:{}}]
                    },
                    {type:"bottom", name:"mainbottom", actions:[ 
                          {action:'hide', properties:{}}]
                    },
                    {type:"col", name:"toolbar1", actions:[ 
                          {action:'hide', properties:{}}]
                    },
                    {type:"left", name:"", actions:[ 
                          {action:'hide', properties:{}}]
                    },
                    {type:"row", name:"toolbarmode2", actions:[ 
                          {action:'show', properties:{}}]
                    },
                     {type:"col", name:"colleftmode3", actions:[ 
                          {action:'hide', properties:{}}]
                    }, 
                    {type:"panel", name:"controlpanel" ,actions:[ 
                          {action:'hide', properties:{}}]
                    },
                    {type:"panel", name:"zoom" ,actions:[ 
                          {action:'hide', properties:{}}]
                    },
                    {type:"panel", name:"legend" ,actions:[ 
                          {action:'hide', properties:{}}]
                    }
                ]
            }, 
             {
                id:"mode2",
                tasks:[
                    {type:"row", name:"header", actions:[ 
                          {action:'show', properties:{}}]
                    },
                    {type:"row", name:"menu", actions:[ 
                          {action:'show', properties:{}}]
                    },
                    {type:"row", name:"toolbar", actions:[ 
                          {action:'show', properties:{}}]
                    },
                    {type:"bottom", name:"mainbottom", actions:[ 
                          {action:'show', properties:{}}]
                    },
                    {type:"col", name:"toolbar1", actions:[ 
                          {action:'show', properties:{}}]
                    },
                    {type:"left", name:"", actions:[ 
                          {action:'show', properties:{}}]
                    },
                    {type:"row", name:"toolbarmode2", actions:[ 
                          {action:'hide', properties:{}}]
                    },
                     {type:"col", name:"colleftmode3", actions:[ 
                          {action:'hide', properties:{}}]
                    }, 
                    {type:"panel", name:"controlpanel" ,actions:[ 
                          {action:'show', properties:{}}]
                    },
                    {type:"panel", name:"zoom" ,actions:[ 
                          {action:'show', properties:{}}]
                    },
                    {type:"panel", name:"legend" ,actions:[ 
                          {action:'show', properties:{}}]
                    }
                ]
            },
            {
                id:"mode3",
                tasks:[
                    {type:"row", name:"header", actions:[ 
                          {action:'hide', properties:{}}]
                    },
                    {type:"row", name:"menu", actions:[ 
                          {action:'hide', properties:{}}]
                    },
                    {type:"row", name:"toolbar", actions:[ 
                          {action:'hide', properties:{}}]
                    },
                    {type:"bottom", name:"mainbottom", actions:[ 
                          {action:'hide', properties:{}}]
                    },
                    {type:"col", name:"toolbar1", actions:[ 
                          {action:'hide', properties:{}}]
                    },
                    {type:"left", name:"", actions:[ 
                          {action:'show', properties:{}}]
                    },
                    {type:"row", name:"toolbarmode2", actions:[ 
                          {action:'hide', properties:{}}]
                    },
                    {type:"col", name:"colleftmode3", actions:[ 
                          {action:'show', properties:{}}]
                    }, 
                    {type:"panel", name:"controlpanel" ,actions:[ 
                          {action:'hide', properties:{}}]
                    },
                    {type:"panel", name:"zoom" ,actions:[ 
                          {action:'hide', properties:{}}]
                    },
                    {type:"panel", name:"legend" ,actions:[ 
                          {action:'show', properties:{}}]
                    }

                ]
            }
        ]};

    return objCurrentLayout;
}

 
